<?php
/*
Plugin Name: Obfuscate
Plugin URI: http://designoahu.com/obfuscate-wordpress-plugin
Description: Obfuscate obscures email addresses in your content making it extremely difficult for spam bots to harvest the email address. For more information visit the <a href="http://designoahu.com/obfuscate-wordpress-plugin">Obfuscate WordPress Plugin</a> home page.
Version: 1.2
Author: Jeremy Moseley
Author URI: http://jeremymoseley.com
*/
?>
<?php
/*  Copyright 2007  Jeremy Moseley

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if(!function_exists('str_split')){
	function str_split($text, $split = 1){
		$array = array();
		for($i=0; $i < strlen($text); $i++){
			$key = NULL;
			for ($j = 0; $j < $split; $j++){
				$key .= $text[$i]; 
			}
			array_push($array, $key);
		}
    	return $array;
	}	
}

function obfuscate($text){
	preg_match_all("/[-a-z0-9\._]+@[-a-z0-9\._]+\.[a-z]{2,4}/", $text, $emails);
	$patterns = array();
	$replacements = array();
	foreach($emails[0] as $email){
		if(!in_array("/$email/", $patterns)){
			$obfuscated = '';
			foreach(str_split($email) as $char) {
				$obfuscated .= '&#'.ord($char).';';
			}
			$patterns[] = "/$email/";
			$replacements[] = $obfuscated;
		}
	}
	$text = preg_replace($patterns, $replacements, $text);
	return $text;
}

add_filter('the_content', 'obfuscate', 21);
add_filter('the_excerpt', 'obfuscate', 21);
add_filter('comment_text', 'obfuscate', 21);
add_filter('comment_excerpt', 'obfuscate', 21);
add_filter('the_content_rss', 'obfuscate', 21);
add_filter('the_excerpt_rss', 'obfuscate', 21);
add_filter('comment_text_rss', 'obfuscate', 21);
add_filter('the_author_email', 'obfuscate', 21);
add_filter('comment_author_email', 'obfuscate', 21);
?>