#!/usr/bin/perl
# also removes those barcodes
use warnings;
use strict;

my $qseq_1 = $ARGV[0];
my $qseq_2 = $ARGV[1];
my $out = $ARGV[2];

open QSEQ1, $qseq_1;
open QSEQ2, $qseq_2;
open OUT1, ">$out"."_R1.fastq";
open OUT2, ">$out"."_R2.fastq";

while (my $seq1 = <QSEQ1>){
	my $seq2 = (<QSEQ2>);
	chomp $seq1;
	chomp $seq2;
	my @tabs1 = split "\t", $seq1;
	my @tabs2 = split "\t", $seq2;
	if (($tabs1[10]==1)and($tabs2[10]==1)) {
		print OUT1 "@"."$tabs1[0]\:$tabs1[2]\:$tabs1[3]:$tabs1[4]\:$tabs1[5]\#0\/1\n$tabs1[8]\n+\n$tabs1[9]\n";
		print OUT2 "@"."$tabs2[0]\:$tabs2[2]\:$tabs2[3]:$tabs2[4]\:$tabs2[5]\#0\/2\n$tabs2[8]\n+\n$tabs2[9]\n";
	}
}
