#!/usr/bin/perl
# also removes those barcodes
use warnings;
use strict;

#unless (@ARGV == 4) {die;}
my $bar = $ARGV[0];
my $fastq_1 = $ARGV[1];
my $fastq_2 = $ARGV[2];
my $out = $ARGV[3];

# get the barcodes
my %bar;
my %c_fail;

my %ph;

open IN, $bar;
while (<IN>){
	chomp;
	my @a = split (/\t/,$_);
	$bar{$a[1]}=$a[0]; 
}
close IN;

open FAST1, $fastq_1;
open FAST2, $fastq_2;
open OUT, ">$out";
my $c;
my $line_tracker;
my %read_info;
while (my $seq1 = <FAST1>){
	my $seq2 = (<FAST2>);
	chomp $seq1;
	chomp $seq2;
	$c++;
	$line_tracker++;
	if ($line_tracker == 1){
		$read_info{"R1"}{"header"} = $seq1;
		$read_info{"R2"}{"header"} = $seq2;
	} 
	if ($line_tracker == 2){
		$read_info{"R1"}{"seq"} = $seq1;
		$read_info{"R2"}{"seq"} = $seq2;
	} 
	if ($line_tracker == 4){
		$line_tracker = '';
		$read_info{"R1"}{"qual"} = $seq1;
		$read_info{"R2"}{"qual"} = $seq2;
		my $read = $read_info{"R1"}{"seq"};
		my $qual = $read_info{"R1"}{"qual"};	
            my $read2 = $read_info{"R2"}{"seq"} ;
		my $qual2 = $read_info{"R2"}{"qual"};
		my $bar_number;
		my $bcseq;
		foreach my $i (4..9){
			my $tmp = $read;
			my $bc = substr($tmp,0,$i);
			if ($bar{$bc}){
				# check that the RE site is there
				my $re_site = substr($tmp,($i),5);
				if ($re_site eq "TGCAG"){
					$bar_number = $bar{$bc};
					$bcseq = $bc; 	
				}
			}
		}	

		if ($bar_number){
			my $l = length($bcseq);
			my $FakeQual = substr($qual, 0, $l); 
			print OUT $read_info{"R1"}{"header"}."\n$read\n+\n$qual\n";
			print OUT $read_info{"R2"}{"header"}."\n$bcseq"."$read2\n+\n$FakeQual"."$qual2\n";			
		}
	}
}


